/**HEADER********************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: fxlc95000.h$
* $Version : 1.0.0.0$
* $Date    : June-8-2012$
*
* Comments:
*
*   This file contains psp defines.
*
*END************************************************************************/

#ifndef _FXLC95000_PSP_H
#define _FXLC95000_PSP_H



#ifdef __cplusplus
extern "C" {
#endif


#ifndef __ASM__
/* Include registers for modules common to all Coldfire processors */
//#include <fxlc95xxx_i2c.h>
#endif

/*------------------------------------------------------------------------*/
/*
**                    CONSTANT DEFINITIONS
*/

/* Indicate processor type */
#define PSP_FXLC95000                       1

#define PSP_HAS_DSP                         0
#define PSP_HAS_EMAC                        0

/*
** Cache and MMU definition values
*/
#define PSP_HAS_MMU                         0
#define PSP_HAS_CODE_CACHE                  0
#define PSP_HAS_DATA_CACHE                  0
//#define PSP_CACHE_LINE_SIZE                 (0x10)
#define PSP_STOP_ON_IDLE                    0

/*
/** Test for disable cpu wait mode macro.
*/
#if PSP_STOP_ON_IDLE
   #warning "With PSP_STOP_ON_IDLE and no idle_task USB doesn't recover from wait mode"
#endif



#ifndef __ASM__

/* Do you want to verify kernel data can be read and written correctly */
#define PSP_KERNEL_DATA_VERIFY_ENABLE       ((uint_32)__KERNEL_DATA_VERIFY_ENABLE)

/*
** Standard cache macros
*/
#define _DCACHE_FLUSH()
#define _DCACHE_FLUSH_LINE(p)
#define _DCACHE_FLUSH_MBYTES(p, m)
#define _DCACHE_INVALIDATE()
#define _DCACHE_INVALIDATE_LINE(p)
#define _DCACHE_INVALIDATE_MBYTES(p, m)

#define _CACHE_ENABLE(n)
#define _CACHE_DISABLE()

#define _ICACHE_INVALIDATE()
#define _ICACHE_INVALIDATE_LINE(p)
#define _ICACHE_INVALIDATE_MBYTES(p, m)





/**************** interrupt vector table ****************/
#define INT_OFFSET_INITSP                          0x0000U
#define INT_OFFSET_INITPC                          0x0004U
#define INT_OFFSET_Vaccerr                         0x0008U
#define INT_OFFSET_Vadderr                         0x000CU
#define INT_OFFSET_Viinstr                         0x0010U
#define INT_OFFSET_VReserved5                      0x0014U
#define INT_OFFSET_VReserved6                      0x0018U
#define INT_OFFSET_VReserved7                      0x001CU
#define INT_OFFSET_Vprviol                         0x0020U
#define INT_OFFSET_Vtrace                          0x0024U
#define INT_OFFSET_Vunilaop                        0x0028U
#define INT_OFFSET_Vunilfop                        0x002CU
#define INT_OFFSET_Vdbgi                           0x0030U
#define INT_OFFSET_VReserved13                     0x0034U
#define INT_OFFSET_Vferror                         0x0038U
#define INT_OFFSET_VReserved15                     0x003CU
#define INT_OFFSET_VReserved16                     0x0040U
#define INT_OFFSET_VReserved17                     0x0044U
#define INT_OFFSET_VReserved18                     0x0048U
#define INT_OFFSET_VReserved19                     0x004CU
#define INT_OFFSET_VReserved20                     0x0050U
#define INT_OFFSET_VReserved21                     0x0054U
#define INT_OFFSET_VReserved22                     0x0058U
#define INT_OFFSET_VReserved23                     0x005CU
#define INT_OFFSET_Vspuri                          0x0060U
#define INT_OFFSET_VReserved25                     0x0064U
#define INT_OFFSET_VReserved26                     0x0068U
#define INT_OFFSET_VReserved27                     0x006CU
#define INT_OFFSET_VReserved28                     0x0070U
#define INT_OFFSET_VReserved29                     0x0074U
#define INT_OFFSET_VReserved30                     0x0078U
#define INT_OFFSET_VReserved31                     0x007CU
#define INT_OFFSET_Vtrap0                          0x0080U
#define INT_OFFSET_Vtrap1                          0x0084U
#define INT_OFFSET_Vtrap2                          0x0088U
#define INT_OFFSET_Vtrap3                          0x008CU
#define INT_OFFSET_Vtrap4                          0x0090U
#define INT_OFFSET_Vtrap5                          0x0094U
#define INT_OFFSET_Vtrap6                          0x0098U
#define INT_OFFSET_Vtrap7                          0x009CU
#define INT_OFFSET_Vtrap8                          0x00A0U
#define INT_OFFSET_Vtrap9                          0x00A4U
#define INT_OFFSET_Vtrap10                         0x00A8U
#define INT_OFFSET_Vtrap11                         0x00ACU
#define INT_OFFSET_Vtrap12                         0x00B0U
#define INT_OFFSET_Vtrap13                         0x00B4U
#define INT_OFFSET_Vtrap14                         0x00B8U
#define INT_OFFSET_Vtrap15                         0x00BCU
#define INT_OFFSET_VReserved48                     0x00C0U
#define INT_OFFSET_VReserved49                     0x00C4U
#define INT_OFFSET_VReserved50                     0x00C8U
#define INT_OFFSET_VReserved51                     0x00CCU
#define INT_OFFSET_VReserved52                     0x00D0U
#define INT_OFFSET_VReserved53                     0x00D4U
#define INT_OFFSET_VReserved54                     0x00D8U
#define INT_OFFSET_VReserved55                     0x00DCU
#define INT_OFFSET_VReserved56                     0x00E0U
#define INT_OFFSET_VReserved57                     0x00E4U
#define INT_OFFSET_VReserved58                     0x00E8U
#define INT_OFFSET_VReserved59                     0x00ECU
#define INT_OFFSET_VReserved60                     0x00F0U
#define INT_OFFSET_Vunsinstr                       0x00F4U
#define INT_OFFSET_VReserved62                     0x00F8U
#define INT_OFFSET_VReserved63                     0x00FCU
#define INT_OFFSET_Virq                            0x0100U
#define INT_OFFSET_Vframe_err                      0x0104U
#define INT_OFFSET_VReserved66                     0x0108U
#define INT_OFFSET_VReserved67                     0x010CU
#define INT_OFFSET_VReserved68                     0x0110U
#define INT_OFFSET_VReserved69                     0x0114U
#define INT_OFFSET_Vtpm1ovf                        0x0118U
#define INT_OFFSET_Vtpm1ch0                        0x011CU
#define INT_OFFSET_Vtpm1ch1                        0x0120U
#define INT_OFFSET_VReserved73                     0x0124U
#define INT_OFFSET_VReserved74                     0x0128U
#define INT_OFFSET_Vmtim                           0x012CU
#define INT_OFFSET_Vpdb_a                          0x0130U
#define INT_OFFSET_Vpdb_b                          0x0134U
#define INT_OFFSET_VReserved78                     0x0138U
#define INT_OFFSET_VReserved79                     0x013CU
#define INT_OFFSET_VReserved80                     0x0140U
#define INT_OFFSET_VReserved81                     0x0144U
#define INT_OFFSET_Vsp_wake                        0x0148U
#define INT_OFFSET_VReserved83                     0x014CU
#define INT_OFFSET_VReserved84                     0x0150U
#define INT_OFFSET_VReserved85                     0x0154U
#define INT_OFFSET_VReserved86                     0x0158U
#define INT_OFFSET_VReserved87                     0x015CU
#define INT_OFFSET_VReserved88                     0x0160U
#define INT_OFFSET_VReserved89                     0x0164U
#define INT_OFFSET_Vsp_to_0                        0x0168U
#define INT_OFFSET_Vsp_to_1                        0x016CU
#define INT_OFFSET_VReserved92                     0x0170U
#define INT_OFFSET_VReserved93                     0x0174U
#define INT_OFFSET_VReserved94                     0x0178U
#define INT_OFFSET_Vstart_of_frame                 0x017CU
#define INT_OFFSET_VConvComplete                   0x0180U
#define INT_OFFSET_VReserved97                     0x0184U
#define INT_OFFSET_VReserved98                     0x0188U
#define INT_OFFSET_VReserved99                     0x018CU
#define INT_OFFSET_VReserved100                    0x0190U
#define INT_OFFSET_Vmaster_i2c                     0x0194U
#define INT_OFFSET_VReserved102                    0x0198U
#define INT_OFFSET_VL7swi                          0x019CU
#define INT_OFFSET_VL6swi                          0x01A0U
#define INT_OFFSET_VL5swi                          0x01A4U
#define INT_OFFSET_VL4swi                          0x01A8U
#define INT_OFFSET_VL3swi                          0x01ACU
#define INT_OFFSET_VL2swi                          0x01B0U
#define INT_OFFSET_VL1swi                          0x01B4U
#define INT_OFFSET_VReserved110                    0x01B8U
#define INT_OFFSET_VReserved111                    0x01BCU
#define INT_OFFSET_VReserved112                    0x01C0U
#define INT_OFFSET_VReserved113                    0x01C4U
#define INT_OFFSET_VReserved114                    0x01C8U


// Required for io_gpio_fxlc95000_prv.h.  Include this in io_gpio_prv.h
// under the fxlc95000 case.
typedef enum {
   GPIO_PORT_A = 0,
   GPIO_PORT_B,
   GPIO_PORT_C,
   GPIO_PORT_D,
   GPIO_PORT_E,
   GPIO_PORT_F,
   GPIO_PORT_G,
   GPIO_PORT_H,
   GPIO_PORT_J,
   GPIO_PORT_MAX
} gpio_port_t;



/*------------------------------------------------------------------------*/
/*
**                      FUNCTION PROTOTYPES AND GLOBAL EXTERNS
*/

//extern volatile uint_32 _psp_saved_cacr;
//extern volatile uint_32 _psp_saved_acr0;
//extern volatile uint_32 _psp_saved_acr1;
extern          unsigned char   __KERNEL_DATA_VERIFY_ENABLE[]; // CR1327

extern void    _fxlc95000_initialize_support(unsigned long);





/***********************************************/
/**   D E P R E C I A T E D   S Y M B O L S   **/
/***********************************************/
#pragma options align=reset


#endif //__ASM__

#ifdef __cplusplus
}
#endif

#endif
/*lint -restore  +esym(961,18.4) +esym(961,19.7) Enable MISRA rule (1.1,18.4,6.4,19.7) checking. */
